/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
	The script prints out a message whenever an object is created or destroyed.
	There are also examples of the new format for bhs.dll hooks.
*/

#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "plugin.h"
#include "float.h"

ExampleSettingsStruct *ExampleSettings = 0;

void ExampleSettingsStruct::Load() {
	SettingsLoader::Load();

	LoadFloat(TakeHigher, "TakeHigher");
	LoadFloat(ReceiveLower, "ReceiveLower");
	LoadFloat(PowerPlantMultiplier, "PowerPlantMultiplier");
	LoadFloat(RefineryMultiplier, "RefineryMultiplier");
	LoadFloat(WaitTime, "WaitTime");

}

int ObjectHookID = 0;
ObjectCreateHookStruct *ObjectHookStruct = 0;


void ObjectHookCall(void *data,GameObject *obj) 
{
}


void Plugin_Load() {
	ExampleSettings = new ExampleSettingsStruct("wealth_redistribution.ini");
	ExampleSettings->Load();

	ObjectHookStruct = new ObjectCreateHookStruct;
	ObjectHookStruct->hook = ObjectHookCall;
	ObjectHookStruct->data = 0;
	ObjectHookID = AddObjectCreateHook(ObjectHookStruct);

}

void Plugin_Unload() {
	delete ExampleSettings;
	delete ObjectHookStruct;
}

void Wealth_Redistribution::Created(GameObject *o)
{
	Commands->Start_Timer(o,this,ExampleSettings->WaitTime,1);
}
 
void Wealth_Redistribution::Timer_Expired(GameObject *o,int number)
{
	if (number == 1)
	{
		for (int Team = 0; Team < 2; Team++)
		{		
			float TakeHigher = ExampleSettings->TakeHigher; // Starts taking money when yours is higher than this variable
			float ReceiveLower = ExampleSettings->ReceiveLower; // You start receiving money if yours is lower than this variable
			int Amount = 0;
			int Recipients = 0;			

			if(Is_Building_Dead(Find_Refinery(Team)))
			{
				TakeHigher = TakeHigher * ExampleSettings->RefineryMultiplier;
				ReceiveLower = ReceiveLower * ExampleSettings->RefineryMultiplier;
			}
			if(Is_Building_Dead(Find_Power_Plant(Team)))
			{
				TakeHigher = TakeHigher * ExampleSettings->RefineryMultiplier;
				ReceiveLower = ReceiveLower * ExampleSettings->PowerPlantMultiplier;
			}

			for (GenericSLNode* PlayerIter = PlayerList->HeadNode; (PlayerIter != NULL); PlayerIter = PlayerIter->NodeNext)
			{
				cPlayer *p = (cPlayer *)PlayerIter->NodeData;
				if (p->IsActive && Get_Team(p->PlayerId) == Team && Get_Money(p->PlayerId) < ReceiveLower)
				{
					Recipients++;
				}
			}
			if (Recipients > 0)
			{
				for (GenericSLNode* PlayerIter = PlayerList->HeadNode; (PlayerIter != NULL); PlayerIter = PlayerIter->NodeNext)
				{
					cPlayer *p = (cPlayer *)PlayerIter->NodeData;
					if (p->IsActive && Get_Team(p->PlayerId) == Team && Get_Money(p->PlayerId) > TakeHigher)
					{
						int Reduction = (int)Get_Money(p->PlayerId)-(int)TakeHigher;
						Purchase_Item(Get_GameObj(p->PlayerId), Reduction);
						Amount += Reduction;
					}
				}
				if (Amount > 0)
				{
					for (GenericSLNode* PlayerIter = PlayerList->HeadNode; (PlayerIter != NULL); PlayerIter = PlayerIter->NodeNext)
					{
						cPlayer *p = (cPlayer *)PlayerIter->NodeData;
						if (p->IsActive && Get_Team(p->PlayerId) == Team && Get_Money(p->PlayerId) < ReceiveLower)
						{
							p->Increment_Money((float)Amount/(float)Recipients);
						}
					}
				}
			}
		}
		Commands->Start_Timer(o,this,ExampleSettings->WaitTime,1);
	}
};

ScriptRegistrant<Wealth_Redistribution> Wealth_Redistribution_Registrant("Wealth_Redistribution", "");

extern "C" {

DLLEXPORT void SSGM_Chat_Hook(int ID, int Type, const wchar_t *Msg) {
}

DLLEXPORT void SSGM_Host_Hook(int ID, int Type, const char *Msg) {
}

DLLEXPORT void SSGM_Player_Join_Hook(int ID, const char *Nick) {
}

DLLEXPORT void SSGM_Player_Leave_Hook(int ID) {
}

DLLEXPORT void SSGM_Level_Loaded_Hook() 
{
	GameObject *obj = Commands->Create_Object("Invisible_Object", Vector3(0.0, 0.0, 0.0));
	Attach_Script_Once(obj, "Wealth_Redistribution", "");
}

DLLEXPORT void SSGM_GameOver_Hook() {
}

DLLEXPORT void SSGM_Console_Output_Hook(const char *Output) {
}
}


